/*
 * File:		sysinit.c
 * Purpose:		Reset configuration of the M52259DEMOMCU
 * 
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#include "support_common.h"

/********************************************************************/

void mcf5225x_init(void);
void mcf5225x_wtm_init(void);
void mcf5225x_pll_init(void);
void mcf5225x_scm_init(void);

extern __declspec(system)  uint8 __DATA_ROM[];
extern __declspec(system)  uint8 __DATA_RAM[];
extern __declspec(system)  uint8 __DATA_END[];
extern __declspec(system)  uint8 __BSS_START[];
extern __declspec(system)  uint8 __BSS_END[];
extern uint32 VECTOR_TABLE[];

/********************************************************************/
void
mcf5225x_init(void)
{
	register uint32 n;
	register uint8 *dp, *sp;


	/* Enable debug */
	MCF_GPIO_PDDPAR = 0x0F;
	mcf5xxx_wr_vbr((uint32)VECTOR_TABLE);
	

	/*
	 * Move initialized data from ROM to RAM.
	 */
	if (__DATA_ROM != __DATA_RAM)
	{
		dp = (uint8 *)__DATA_RAM;
		sp = (uint8 *)__DATA_ROM;
		n = (uint32)(__DATA_END - __DATA_RAM);
		while (n--)
			*dp++ = *sp++;
	}

	/*
	 * Zero uninitialized data
	 */
	if (__BSS_START != __BSS_END)
	{
		sp = (uint8 *)__BSS_START;
		n = (uint32)(__BSS_END - __BSS_START);
		while (n--)
			*sp++ = 0;
	}
	mcf5225x_wtm_init();
	mcf5225x_pll_init();
	mcf5225x_scm_init();
	
}
/********************************************************************/
void
mcf5225x_wtm_init(void)
{
	/*
	 * Disable Software Watchdog Timer
	 */
	MCF_SCM_CWCR = 0;
}
/********************************************************************/
void
mcf5225x_pll_init(void)
{


/*Required if booting with internal relaxation oscillator on, crystal off, & pll off, clkmod[1:0]=00 & xtal=1 */

	MCF_CLOCK_OCLR = 0xC0;    //turn on crystal
	MCF_CLOCK_CCLR = 0x00;    //switch to crystal 
    MCF_CLOCK_OCHR = 0x00;    //turn off relaxation osc

/*---------------------------------------------------------------------------------*/


	/* The PLL pre divider - 48MHz / 6 = 8MHz */
	MCF_CLOCK_CCHR =0x05;
	 
	 
	/* The PLL pre-divider affects this! 
	 * Multiply 48Mhz reference crystal /CCHR by 10 to acheive system clock of 80Mhz
	 */

	MCF_CLOCK_SYNCR &= ~(MCF_CLOCK_SYNCR_PLLEN);

    MCF_CLOCK_SYNCR |= MCF_CLOCK_SYNCR_CLKSRC | MCF_CLOCK_SYNCR_PLLMODE;
	
	//80
	MCF_CLOCK_SYNCR |= MCF_CLOCK_SYNCR_MFD(3) | MCF_CLOCK_SYNCR_RFD(0);
	//64
	//MCF_CLOCK_SYNCR = MCF_CLOCK_SYNCR_MFD(2) | MCF_CLOCK_SYNCR_RFD(0);
	//16
	//MCF_CLOCK_SYNCR = MCF_CLOCK_SYNCR_MFD(2) | MCF_CLOCK_SYNCR_RFD(2);
	//8
	//MCF_CLOCK_SYNCR = MCF_CLOCK_SYNCR_MFD(2) | MCF_CLOCK_SYNCR_RFD(3);
	//1
	//MCF_CLOCK_SYNCR = MCF_CLOCK_SYNCR_MFD(2) | MCF_CLOCK_SYNCR_RFD(6);
	
	MCF_CLOCK_SYNCR |= MCF_CLOCK_SYNCR_PLLEN;

	
	while (!(MCF_CLOCK_SYNSR & MCF_CLOCK_SYNSR_LOCK))
	{
	}
}
/********************************************************************/
void
mcf5225x_scm_init(void)
{
	/*
	 * Enable on-chip modules to access internal SRAM
	 */
	MCF_SCM_RAMBAR = (0
		| MCF_SCM_RAMBAR_BA((uint16)RAMBAR_ADDRESS)
		| MCF_SCM_RAMBAR_BDE);
}
/********************************************************************/
